/*
====================================================================================================

    Copyright (C) 2020 RRe36

    All Rights Reserved unless otherwise explicitly stated.


    By downloading this you have agreed to the license and terms of use.
    These can be found inside the included license-file
    or here: https://rre36.com/copyright-license

    Violating these terms may be penalized with actions according to the Digital Millennium
    Copyright Act (DMCA), the Information Society Directive and/or similar laws
    depending on your country.

====================================================================================================
*/

layout(location = 0) out vec4 data0;

#include "/lib/head.glsl"

#include "/lib/util/colorspace.glsl"

#define g_shadow

in vec2 coord;

in vec3 scenePos;
in vec3 worldPos;

in vec4 tint;

flat in int matID;

uniform sampler2D gcolor;

uniform sampler2D noisetex;

uniform int blockEntityId;

uniform float frameTimeCounter;

#define FUTIL_ROT2
#include "/lib/fUtil.glsl"

uniform vec3 lightvec;

#include "/lib/util/bicubic.glsl"

const float viewDist = 0.0;

#include "/lib/atmos/waterWaves.glsl"

#define shadowmapTextureMipBias 1   //[0 1 2 3 4]

vec3 waterNormal() {
    vec3 pos    = worldPos;

    float dstep   = 0.01;

    vec2 delta;
        delta.x     = waterWaves(pos + vec3( dstep, 0.0, -dstep));
        delta.y     = waterWaves(pos + vec3(-dstep, 0.0,  dstep));
        delta      -= waterWaves(pos + vec3(-dstep, 0.0, -dstep));

    return normalize(vec3(-delta.x, 2.0 * dstep, -delta.y));
}

float projectedCaustic(vec3 pos, vec3 normal, vec3 lightDir) {
    vec3 dPdx   = dFdx(pos);
    vec3 dPdy   = dFdx(pos);

    float num   = selfDot3(dPdx) * selfDot3(dPdy);

    vec3 refractLight = refract(-lightDir, normal, rcp(1.33));
        dPdx   += 2.0 * dFdx(refractLight);
        dPdy   += 2.0 * dFdx(refractLight);

    float denom = selfDot3(dPdx) * selfDot3(dPdy);

    return sqrt(num * rcp(denom));
}

void main() {
    if (blockEntityId == 10201) discard;

    #if DIM == 1
        vec3 lightvec     = normalize(vec3(0.0, 1.0, 0.0));
            lightvec.yz   = rotatePos(lightvec.yz, radians(sunPathRotation));
            lightvec      = normalize(lightvec);
    #endif

    if (matID == 102) {

        vec3 waves  = waterNormal();
        vec3 refractLight = refract(lightvec, waves, rcp(1.33));
        float caustic   = dot(refractLight, lightvec);
            //caustic     = (waves.x + waves.z);
            caustic     = pow(caustic, 2.0) * sign(caustic);
        data0           = vec4(saturate(caustic), saturate(-caustic), sqrt(projectedCaustic(scenePos, waves, lightvec) * 0.4), 0.95);

    } else {

        data0           = texture(gcolor, coord, -shadowmapTextureMipBias);
        if (data0.a<0.1) discard;
            data0.rgb *= tint.rgb;

        data0.rgb  = linearToAP1Albedo(toLinear(data0.rgb));
        data0.rgb  = sqrt(data0.rgb);

        if (data0.a < 0.98) data0.a = saturate(data0.a - 0.1) * 0.88 + 0.1;
        
    }
}